/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.util;

import com.almostreliable.summoningrituals.util.Bruhtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class SerializeUtils {
    private SerializeUtils() {
    }

    public static Vec3i vec3FromJson(JsonObject json) {
        int x = GsonHelper.m_13824_((JsonObject)json, (String)"x", (int)0);
        int y = GsonHelper.m_13824_((JsonObject)json, (String)"y", (int)0);
        int z = GsonHelper.m_13824_((JsonObject)json, (String)"z", (int)0);
        return new Vec3i(x, y, z);
    }

    public static JsonObject vec3ToJson(Vec3i vec) {
        JsonObject json = new JsonObject();
        json.addProperty("x", (Number)vec.m_123341_());
        json.addProperty("y", (Number)vec.m_123342_());
        json.addProperty("z", (Number)vec.m_123343_());
        return json;
    }

    public static Vec3i vec3FromNetwork(FriendlyByteBuf buffer) {
        int x = buffer.m_130242_();
        int y = buffer.m_130242_();
        int z = buffer.m_130242_();
        return new Vec3i(x, y, z);
    }

    public static void vec3ToNetwork(FriendlyByteBuf buffer, Vec3i vec) {
        buffer.m_130130_(vec.m_123341_());
        buffer.m_130130_(vec.m_123342_());
        buffer.m_130130_(vec.m_123343_());
    }

    public static JsonObject stackToJson(ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("stack is empty");
        }
        JsonObject json = new JsonObject();
        json.addProperty("item", Bruhtils.getId(stack.m_41720_()).toString());
        json.addProperty("count", (Number)stack.m_41613_());
        if (stack.m_41782_()) {
            assert (stack.m_41783_() != null);
            json.addProperty("nbt", stack.m_41783_().toString());
        }
        return json;
    }

    public static Block blockFromId(@Nullable ResourceLocation id) {
        return (Block)SerializeUtils.getFromRegistry(ForgeRegistries.BLOCKS, id);
    }

    public static EntityType<?> mobFromId(@Nullable ResourceLocation id) {
        return (EntityType)SerializeUtils.getFromRegistry(ForgeRegistries.ENTITIES, id);
    }

    public static EntityType<?> mobFromJson(JsonObject json) {
        ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"mob"));
        return SerializeUtils.mobFromId(id);
    }

    public static EntityType<?> mobFromNetwork(FriendlyByteBuf buffer) {
        ResourceLocation id = new ResourceLocation(buffer.m_130277_());
        return SerializeUtils.mobFromId(id);
    }

    public static Map<String, String> mapFromJson(JsonObject json) {
        return json.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).getAsString()));
    }

    public static JsonObject mapToJson(Map<String, String> map) {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            json.addProperty(entry.getKey(), entry.getValue());
        }
        return json;
    }

    public static Map<String, String> mapFromNetwork(FriendlyByteBuf buffer) {
        HashMap<String, String> map = new HashMap<String, String>();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            map.put(buffer.m_130277_(), buffer.m_130277_());
        }
        return map;
    }

    public static void mapToNetwork(FriendlyByteBuf buffer, Map<String, String> map) {
        buffer.m_130130_(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            buffer.m_130070_(entry.getKey());
            buffer.m_130070_(entry.getValue());
        }
    }

    public static CompoundTag nbtFromString(String nbtString) {
        try {
            return TagParser.m_129359_((String)nbtString);
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException("Invalid NBT string: " + nbtString, e);
        }
    }

    private static <T extends IForgeRegistryEntry<T>> T getFromRegistry(IForgeRegistry<T> registry, @Nullable ResourceLocation id) {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        IForgeRegistryEntry entry = registry.getValue(id);
        if (entry == null) {
            throw new IllegalArgumentException(id + " is not registered");
        }
        return (T)entry;
    }
}

